' ************************************************
' ********* LOUDSPEAKER ANALYSIS PROGRAM *********
' *********           VER 3.00           *********
' ************************************************

' REV 1.10 WAS RELEASED ON 12/04/86
' REV 2.06 WAS RELEASED ON 10/04/87
' REV 2.10 WAS RELEASED ON 11/26/88
' REV 3.00 WAS RELEASED ON 11/28/91 (last planned release)

' THIS PROGRAM COMPILES UNDER SPECTRA PUBLISHING'S POWER BASIC 2.01
' WITH SOME CHANGES IT COULD COMPILE UNDER OTHER BASIC COMPILERS.
' THE SOURCE CODE IS NOW INCLUDED FOR THOSE WHO WISH TO CUSTOMIZE THE  
' PROGRAM FOR THEIR OWN NEEDS.  THE SOURCE CODE IS BY NO MEANS AN
' EXAMPLE OF GOOD PROGRAMMING, NOR DOES IT TAKE ADVANTAGE OF MANY OF THE
' FEATURES OF THE COMPILER.

' ROUTINES COLLECTED FROM VARIOUS SOURCES INCLUDING WEEM'S SPEAKER BOOK,
' SPEAKER BUILDER MAGAZINE, AND THE LOUDSPEAKER COOKBOOK.

'************************** BEGINNING OF LISTING ***************************

$COMPILE EXE                 'COMPILER METASTRINGS (OPTIONAL)
$CPU 8086
$DEBUG MAP OFF
$ERROR ALL OFF
$FLOAT EMULATE               'EMULATE COPROCESSOR FOR MOST OF PROGRAM
$LIB COM OFF, GRAPH ON
$OPTION CNTLBREAK OFF
$INCLUDE "REGNAMES.INC"      'NECESSARY FOR BIOS CALLS USED IN VIDEO DETECTION

ON ERROR GOTO DAMAGECONTROL
DEFDBL A-Z
DIM M(200)                   'HOLDS THE GRAPH DATA POINTS
DIM BUFFER%(64)              'BUFFER FOR INITIAL VIDEO DATA DUMP
VERSION$="VERSION 3.00"
PI=ATN(1) * 4                'CALCULATE PI
RESOL%=2                     'DEFAULT GRAPH AND CALC RESOLUTION (1 TO 20 HZ)
RESCA=0.05                   'RESCALE VALUE FOR LOG GRAPHS
AUTOFLAG%=0                  'KEEP TRACK OF VIDEO INITIALIZATION METHOD
RANDOMIZE TIMER              'SEED THE RANDOM NUMBER GENERATOR

CALL SETUPDATAIN             'READ SETUP FILE ON DISK
CALL SETUPCHECK              'CHECK FOR CONTRASTING COLORS

IF VIDEOTYPE$="AUTO" THEN CALL LOOKFOVID:AUTOFLAG%=1

IF VIDEOTYPE$="HERC" THEN
  SCREEN 3
  CALL FIRSTSCREEN1
  CALL WAITFOKEY
END IF

IF VIDEOTYPE$="CGA" THEN
  SCREEN 2
  CALL FIRSTSCREEN1
  CALL WAITFOKEY
END IF

IF VIDEOTYPE$="EGA" THEN
  SCREEN 8
  COLOR KOLORA%, KOLORB%
  CALL FIRSTSCREEN1
  CALL FIRSTSCREEN2
  CALL ROTATE
END IF

IF VIDEOTYPE$="VGA" THEN
  SCREEN 9
  COLOR KOLORA%, KOLORB%
  CALL FIRSTSCREEN1
  CALL FIRSTSCREEN2
  CALL ROTATE
END IF

DO                         'FIRST MENU SCREEN & MAIN PROGRAM LOOP
  SCREEN 0
  IF RIGHT$(VIDEOTYPE$,2)="GA" THEN COLOR KOLORA%,KOLORB%
  CLS
  LOCATE 3,26:PRINT"LOUDSPEAKER ANALYSIS PROGRAM"
  LOCATE 4,35:PRINT"MENU #1"
  LOCATE 8,23:PRINT"1. LOAD driver data from disk"
  LOCATE 9,23:PRINT"2. automatic PORTED enclosure design"
  LOCATE 10,23:PRINT"3. manual PORTED enclosure design"
  LOCATE 11,23:PRINT"4. SEALED enclosure design"
  LOCATE 12,23:PRINT"5. calculate maximum POWER levels"
  LOCATE 13,23:PRINT"6. UTILITIES menu"
  LOCATE 14,23:PRINT"7. SAVE driver data to disk"
  LOCATE 15,23:PRINT"8. EXIT to DOS"
  LOCATE 22,28:PRINT"ENTER SELECTION (1-8)"

  CALL WAITFOKEY

  SELECT CASE VAL(K$)
    CASE 1
      CALL DRIVERDATIN
    CASE 2
      GOSUB OPTPORTED
    CASE 3
      GOSUB MODPORTED
    CASE 4
      GOSUB SEALED
    CASE 5
      CALL MAXPOWER
    CASE 6
      CALL MENUTWO
    CASE 7
      CALL DRIVERDATOUT
    CASE 8
      GOSUB BYEBYE
  END SELECT
LOOP

'-----------------------------END OF MAIN PROGRAM LOOP----------------------


SUB MENUTWO                  'SECOND MENU SCREEN
  SHARED K$
  DO
    CLS
    LOCATE 3,26:PRINT"LOUDSPEAKER ANALYSIS PROGRAM"
    LOCATE 4,35:PRINT"MENU #2"
    LOCATE 22,28:PRINT"ENTER SELECTION (1-9)"
    LOCATE 8,23:PRINT"1. calculate PORT dimensions"
    LOCATE 9,23:PRINT"2. calculate ENCLOSURE dimensions"
    LOCATE 10,23:PRINT"3. CONVERT liters or cubic feet"
    LOCATE 11,23:PRINT"4. CROSSOVER design aid"
    LOCATE 12,23:PRINT"5. SETUP display, colors, and path"
    LOCATE 13,23:PRINT"6. calculate DRIVER parameters (advanced users)"
    LOCATE 14,23:PRINT"7. shell to DOS (return with 'exit' command)"
    LOCATE 15,23:PRINT"8. n/a"
    LOCATE 16,23:PRINT"9. RETURN to main menu"
    LOCATE 22,28:PRINT"ENTER SELECTION (1-9)"

    CALL WAITFOKEY

    SELECT CASE VAL(K$)
      CASE 1
        CALL VENTLENGTH
      CASE 2
        CALL BOXSIZE
      CASE 3
        CALL VOLCONVERT
      CASE 4
        CALL CROSSOVER
      CASE 5
        CALL SETUPDATAOUT
      CASE 6
        CALL PARAMCALC
      CASE 7
        CALL DOSSHELL
      CASE 8
        CALL FOOLISHNESS
    END SELECT
    IF VAL(K$)=9 THEN EXIT LOOP
  LOOP
END SUB

SUB PARAMCALC SHARED         'CALCULATE DRIVER PARAMETERS FROM MEASUREMENTS
  CLS
  LOCATE 3,26:PRINT"DRIVER PARAMETER CALCULATOR"
  PRINT:PRINT:PRINT
  OD$=D$
  PRINT" Enter driver name (default is ";OD$;")";
  LOCATE ,60
  INPUT D$:IF D$="" THEN D$=OD$
  PRINT

  QUERY$="Enter voice coil resistance in ohms"
  MINALLOWVAL! = 0.001
  MAXALLOWVAL! = 10000
  OLDVAL! = RE
  GOSUB STANDARDDATAIN
  RE = NEWVAL!

  QUERY$="Enter free air resonance in Hertz"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = FS
  GOSUB STANDARDDATAIN
  FS = NEWVAL!

  QUERY$="Enter Z in ohms at"+STR$(FS)+" Hertz"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = ZMAX
  GOSUB STANDARDDATAIN
  ZMAX = NEWVAL!

  RO=ZMAX/RE
  RF=SQR(RO)*RE

  PRINT" Enter the frequency BELOW free air resonance where:"
  QUERY$="Z="+STR$(RF,4)+" ohms"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = F1
  GOSUB STANDARDDATAIN
  F1 = NEWVAL!

  PRINT" Enter the frequency ABOVE free air resonance where:"
  QUERY$="Z="+STR$(RF,4)+" ohms"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = F2
  GOSUB STANDARDDATAIN
  F2 = NEWVAL!

  QMS=FS*SQR(RO)/(F2-F1)
  QES=QMS/(RO-1)
  QTS=QMS*QES/(QMS+QES)

  QUERY$="Enter test box volume in cubic feet"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = TVB
  GOSUB STANDARDDATAIN
  TVB = NEWVAL!

  QUERY$="Enter resonance of driver in box"
  MINALLOWVAL! = FS
  MAXALLOWVAL! = 999
  OLDVAL! = TFS
  GOSUB STANDARDDATAIN
  TFS = NEWVAL!

  VAS=TVB*(1.149*((TFS/FS)^2-1))

  CLS
  LOCATE 3,26:PRINT"CALCULATED DRIVER PARAMETERS"
  LOCATE 6,2
  PRINT D$
  PRINT:PRINT
  PRINT USING " Voice coil resistance = ##.## ohms";RE
  PRINT USING " Free air resonance    = ##.## hertz";FS
  PRINT USING " Qms (mechanical)      = #.####";QMS
  PRINT USING " Qes (electrical)      = #.####";QES
  PRINT USING " Qts (total)           = #.####";QTS
  PRINT USING " Vas (compliance)      = ##.## cubic feet";VAS

  PRINT:PRINT:PRINT" Do you want this data sent to the printer? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN
    LPRINT "Calculated driver parameters for ";D$
    LPRINT
    LPRINT USING "Resistance (DC)      Re= ##.# Ohms";RE
    LPRINT USING "Free air resonance   Fs= ##.# Hertz";FS
    LPRINT USING "Q (mechanical)      Qms= #.####";QMS
    LPRINT USING "Q (electrical)      Qes= #.####";QES
    LPRINT USING "Q (total driver)    Qts= #.####";QTS
    LPRINT USING "compliance          Vas= ##.## cubic feet";VAS
    LPRINT:LPRINT:LPRINT
  END IF
END SUB

OPTPORTED:
  CLS
  LOCATE 3,25:PRINT"OPTIMUM PORTED ENCLOSURE DESIGN"
  DESIGN$="optimal ported"
  PRINT:PRINT:PRINT
  OD$=D$
  PRINT " Enter driver name (default is ";LEFT$(D$,23);")";
  LOCATE ,60
  INPUT D$:IF D$="" THEN D$=OD$
  PRINT

  QUERY$="Enter Qts value"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = QTS
  GOSUB STANDARDDATAIN
  QTS = NEWVAL!                          'GET QTS VALUE

  QUERY$="Enter Vas value"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = VAS
  GOSUB STANDARDDATAIN
  VAS = NEWVAL!                          'GET VAS VALUE

  QUERY$="Enter free air resonance"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = FS
  GOSUB STANDARDDATAIN
  FS = NEWVAL!                           'GET FS VALUE

  VB=20*QTS^3.3*VAS
  FH=.28*(QTS^-1.4)*FS
  FB=1.5*(QTS^.44)*FH

DISPOPTALIGN:
  CLS
  LOCATE 3,31:PRINT"OPTIMUM ALIGNMENT":PRINT:PRINT
  PRINT USING " Qts                   =  ##.###";QTS
  PRINT USING " Vas                   =  ##.### cubic feet";VAS
  PRINT USING " Free air resonance    =  ##.### hertz";FS
  PRINT
  PRINT USING " Enclosure volume      =  ##.### cubic feet";VB
  PRINT USING " Enclosure tuning      =  ##.### hertz";FB
  PRINT USING " System is down 3 dB   @ ###.### hertz";FH
  PRINT
  PRINT USING " Deviation from flat response   = +##.## dB";HUMP!(QTS, VAS, VB)

  PRINT:PRINT:PRINT" Do you wish to resize the enclosure? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN
    QUERY$="Enter new enclosure volume"
    MINALLOWVAL! = .001
    MAXALLOWVAL! = 1E6
    OLDVAL! = VB
    GOSUB STANDARDDATAIN
    VB = NEWVAL!                         'GET VB VALUE
    FH = FS*(VAS/VB)^.44
    FB = FH/(VAS/VB)^.13
    GOTO DISPOPTALIGN:
  END IF

  PRINT" Do you want a printout of this design? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN CALL UNIVPRINT

  PRINT" Do you want to display the response curve? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN
    GOSUB CALCARRAY
    GOSUB PRINTGRAPH
  END IF

RETURN

MODPORTED:
  CLS
  LOCATE 3,24:PRINT"MODIFIED PORTED ENCLOSURE SYSTEM"
  DESIGN$="non-optimal, ported"
  PRINT:PRINT:PRINT
  OD$=D$
  PRINT" Enter driver name (default is ";LEFT$(D$,23);")";
  LOCATE ,60
  INPUT D$:IF D$="" THEN D$=OD$        'GET DRIVER NAME
  PRINT

  QUERY$="Enter Qts value"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = QTS
  GOSUB STANDARDDATAIN
  QTS = NEWVAL!                          'GET QTS VALUE

  QUERY$="Enter Vas value"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = VAS
  GOSUB STANDARDDATAIN
  VAS = NEWVAL!                          'GET VAS VALUE

  QUERY$="Enter free air resonance"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = FS
  GOSUB STANDARDDATAIN
  FS = NEWVAL!                           'GET FS VALUE

  QUERY$="Enter enclosure volume in cubic feet"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 1E6
  OLDVAL! = VB
  GOSUB STANDARDDATAIN
  VB = NEWVAL!                           'GET VB VALUE

  QUERY$="Enter enclosure tuning"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = FB
  GOSUB STANDARDDATAIN
  FB = NEWVAL!                           'GET FB VALUE

  GOSUB CALCARRAY
  GOSUB PRINTGRAPH

  CLS
  LOCATE 10,20:PRINT"Press R to repeat the design routine,"
  LOCATE 12,20:PRINT"      P to print the data, or"
  LOCATE 14,20:PRINT"      any other key to return to the main menu."

  CALL WAITFOKEY

  IF K$="R" OR K$="r" THEN MODPORTED
  IF K$="P" OR K$="p" THEN CALL UNIVPRINT
RETURN

SEALED:                      'SEALED DESIGN ROUTINE

  CLS:LOCATE 3,28:PRINT"SEALED ENCLOSURE DESIGN"
  DESIGN$="sealed"
  PRINT:PRINT:PRINT
  OD$=D$
  PRINT" Enter driver name (default is ";LEFT$(D$,23);")";
  LOCATE ,60
  INPUT D$:IF D$="" THEN D$=OD$        'GET DRIVER NAME
  PRINT

  QUERY$="Enter Qts value"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = QTS
  GOSUB STANDARDDATAIN
  QTS = NEWVAL!                        'GET Qts VALUE

  QUERY$="Enter Vas value"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = VAS
  GOSUB STANDARDDATAIN
  VAS = NEWVAL!                        'GET Vas VALUE

  QUERY$="Enter free air resonance"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = FS
  GOSUB STANDARDDATAIN
  FS = NEWVAL!                         'GET Fs VALUE

  QUERY$="Enter target Qtc value from Qts to 5.0"
  MINALLOWVAL! = QTS+0.01              'PREVENT DIVIDE BY ZERO ERRORS
  MAXALLOWVAL! = 5.0
  OLDVAL! = 0.9
  GOSUB STANDARDDATAIN
  TC=NEWVAL!                           'GET Qtc VALUE

  VB=VAS/((((TC/FS)/QTS*FS)^2)-1)      'FORMULA CONVERTED TO USE QTS INPUT
  A=VAS/VB
  FC=FS*SQR(A+1)
  F3=FC*SQR(((1/TC^2-2)+SQR((1/TC^2-2)^2+4))/2)

DISPSEALED:
  CLS:LOCATE 3,28:PRINT"SEALED ENCLOSURE DESIGN"
  PRINT:PRINT:PRINT
  PRINT USING " Qts                   =  ##.###";QTS
  PRINT USING " Vas                   =  ##.### cubic feet";VAS
  PRINT USING " Free air resonance    =  ##.### hertz";FS
  PRINT
  PRINT USING " Enclosure volume      =  ##.### cubic feet";VB
  PRINT USING " System is down 3 dB   @ ###.### hertz";F3
  PRINT USING " System Q (Qtc)        =  ##.###";TC;
  PRINT " (typically between 0.577 AND 1.2)"
  PRINT USING " Alpha                 =  ##.###";A;
  PRINT " (typically between 3.0 and 10)"
  PRINT USING " Resonant frequency    = ###.### hertz";RFC!(TC, FS, QTS)

  PRINT:PRINT:PRINT

  PRINT" Do you wish to resize the enclosure? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN
    QUERY$="Enter the new enclosure volume"
    MINALLOWVAL!=.01
    MAXALLOWVAL!=1E6
    OLDVAL!=VB
    GOSUB STANDARDDATAIN
    VB=NEWVAL!

    A=VAS/VB
    FC=FS*SQR(A+1)
    TC=(FC*QTS)/FS
    F3=FC*SQR(((1/TC^2-2)+SQR((1/TC^2-2)^2+4))/2)
    GOTO DISPSEALED
  END IF

  PRINT" Do you want a printout of this data? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN CALL UNIVPRINT

  PRINT" Do you wish to display the response curve? (Y/N)"
  CALL WAITFOKEY

  IF K$="Y" OR K$="y" THEN
    GOSUB CALCARRAY2
    GOSUB PRINTGRAPH
    GOTO DISPSEALED
  END IF

RETURN

FUNCTION HUMP!(QTS, VAS, VB)           'AMPLITUDE OF HUMP FOR PORTED BOX
  HUMP!=20*LOG(QTS*(VAS/VB)^.3/.4)/LOG(10)
END FUNCTION

FUNCTION RFC!(TC, FS, QTS)             'RESONANT FREQ OF SEALED BOX SYSTEM
  RFC!=(TC*FS)/QTS
END FUNCTION

CALCARRAY2:
  PRINT:PRINT:PRINT" calculating . . ."
  FOR F%=20 TO 200 STEP RESOL%
  FH=F%/FC:FQ=FH^2:MAG=FQ/(SQR((FQ-1)^2+(FH/TC)^2))
  M(F%)=20*(LOG(MAG)/LOG(10))
  IF M(F%)<-40 THEN M(F%)=-40          'STAY WITHIN THE TOP OF THE GRAPH
  IF M(F%)>10 THEN M(F%)=10            'STAY WITHIN THE BOTTOM OF IT TOO
  NEXT F%
RETURN

STANDARDDATAIN:              'BRING IN ALL FLOATING POINT NUMERIC DATA

  'INPUT PARAMETERS:  MINALLOWVAL!  -  MINIMUM ACCEPTABLE VALUE
  '                   MAXALLOWVAL!  -  MAXIMUM ACCEPTABLE VALUE
  '                   OLDVAL!       -  THE ORIGINAL VALUE AS A DEFAULT
  '                   QUERY$        -  THE PROMPTING STATEMENT

  'OUTPUT PARAMETERS: NEWVAL!       -  THE NEW VALUE

  PRINT " ";QUERY$;" (default is";    'PRINT THE QUESTION AND DEFAULT VALUE
  PRINT ROUND(OLDVAL!,2);
  LOCATE ,POS-1
  PRINT")";

  OLDY%=CSRLIN                         'REMEMBER WHAT LINE WE ARE ON

  DO
    LOCATE OLDY%, 60
    PRINT "           "                'CLEAR THE OLD VALUE (IF ANY)
    LOCATE OLDY%, 60
    INPUT NEWVAL!
    LIMITFLAG% = 1
    IF (NEWVAL! = 0) AND (OLDVAL! <> 0) THEN NEWVAL! = OLDVAL! : EXIT LOOP
    IF NEWVAL! > MAXALLOWVAL! THEN LIMITFLAG% = 0
    IF NEWVAL! < MINALLOWVAL! THEN LIMITFLAG% = 0
  LOOP UNTIL LIMITFLAG% = 1
  PRINT
RETURN

STANDARDINTIN:              'BRING IN ALL STANDARD INTEGER DATA FROM USER
                            'NOTE THAT THIS ROUTINE SUPPLIES NO CURSOR!
  PRINT " ";QUERY$;" (default is";    'PRINT THE QUESTION AND DEFAULT VALUE
  PRINT OLDVAL%;
  LOCATE ,POS-1
  PRINT ")";
  OLDY%=CSRLIN                         'REMEMBER WHAT LINE WE ARE ON

  DO
    LOCATE OLDY%, 60
    PRINT "?_          "                'CLEAR THE OLD VALUE (IF ANY)
    LOCATE OLDY%, 61

    NEWVAL$=""
    K$=""
    K%=0

    DO

      K$=INKEY$                        'GET A SINGLE CHARACTOR

      IF (ASCII(K$)>47) AND (ASCII(K$)<58) THEN  'SEE IF ITS A NUMBER 0-9
        PRINT K$;                                'PRINT IT
        NEWVAL$=NEWVAL$+K$                       'ADD IT TO THE STRING
        K%=K%+1                                  'COUNT HOW MANY DIGITS
      END IF

      IF (ASCII(K$) = 8) AND (K%>0) THEN         'SEE IF ITS A BACKSPACE
        LOCATE ,POS-1                            '  AND DONT GO BELOW ZERO
        PRINT " ";                               'PRINT A BLANK
        LOCATE ,POS-1                            'BACKUP AGAIN
        NEWVAL$=LEFT$(NEWVAL$,LEN(NEWVAL$)-1)    'REMOVE IT FROM THE STRING
        K%=K%-1                                  'SUBTRACT IT FROM THE COUNT
      END IF

    LOOP UNTIL K$=CHR$(13)                       'LOOK FOR CARRIAGE RETURN

    NEWVAL%=INT(VAL(NEWVAL$))                    'PLUCK OUT THE NUMBER

    LIMITFLAG% = 1
    IF NEWVAL$ = "" THEN NEWVAL% = OLDVAL% : EXIT LOOP
    IF NEWVAL% > MAXALLOWVAL% THEN LIMITFLAG% = 0
    IF NEWVAL% < MINALLOWVAL% THEN LIMITFLAG% = 0
  LOOP UNTIL LIMITFLAG% = 1
  PRINT
RETURN

CALCARRAY:
  PRINT:PRINT:PRINT" calculating . . . ."
  A=(FB^2)/(FS^2)
  B=A/QTS+(FB/(7*FS))
  C=1+A+(FB/(7*FS*QTS))+(VAS/VB)
  D=1/QTS+(FB/(7*FS))
  FOR F%=20 TO 200 STEP RESOL%
  F9=F%/FS:F5=F9^2
  F4=F9^4:F3=F9^3
  F6=(F4-C*F5+A)^2
  F7=(B*F9-D*F3)^2
  M(F%)=20*(LOG(F4/(F6+F7)^.5)/LOG(10))
  IF M(F%)<-40 THEN M(F%)=-40       'STAY WITHIN THE TOP OF THE GRAPH
  IF M(F%)>10 THEN M(F%)=10         'STAY WITHIN THE BOTTOM OF IT TOO
  NEXT
RETURN

PRINTGRAPH:
  $FLOAT PROCEDURE
  IF VIDEOTYPE$="HERC" THEN SCREEN 3:WINDOW SCREEN (0,635)-(995,10)
  IF VIDEOTYPE$="CGA" THEN SCREEN 2:WINDOW SCREEN (0,640)-(1000,10)
  IF VIDEOTYPE$="EGA" THEN SCREEN 9:COLOR GRAPHKOLORA%,GRAPHKOLORB%:WINDOW SCREEN (0,640)-(1000,10)
  IF VIDEOTYPE$="VGA" THEN SCREEN 12:COLOR GRAPHKOLORA%,GRAPHKOLORB%:WINDOW SCREEN (0,770)-(1000,12)

  CLS
  LINE (150,50)-(850,550),,B

  FOR VER%=1 TO 9
    VERT%=LOG(VER%)/LOG(10)*700+150
    LINE (VERT%,50)-(VERT%,550),,,&HAAAA
  NEXT VER%

  FOR HOR%=150 TO 550 STEP 100
    LINE (150,HOR%)-(850,HOR%),,,&HCCCC
  NEXT HOR%

  LOCATE 23,11:PRINT" 20               40        60     80   100";
  PRINT"     140      200"
 ' LOCATE 24,33:PRINT"FREQUENCY (HERTZ)"
  LOCATE 2,72:PRINT"+10"
  LOCATE 6,72:PRINT" 0   dB"
  LOCATE 10,72:PRINT"-10"
  LOCATE 14,72:PRINT"-20"
  LOCATE 18,72:PRINT"-30"
  LOCATE 22,72:PRINT"-40"

 'DRAW PLOT
  IF VIDEOTYPE$="EGA" OR VIDEOTYPE$="VGA" THEN COLOR GRAPHKOLORC%

  FOR F%=20 TO 200-RESOL% STEP RESOL%
    FLOG%=LOG(((F%-20)*RESCA)+1)/LOG(10)*700+150
    FLOG1%=LOG(((F%-(20-RESOL%))*RESCA)+1)/LOG(10)*700+150
    LINE (FLOG%,M(F%)*-10+150)-(FLOG1%,M(F%+RESOL%)*-10+150)
  NEXT F%

  IF VIDEOTYPE$="VGA" THEN
    COLOR GRAPHKOLORA%,GRAPHKOLORB%
    LOCATE 26,12:PRINT D$
    LOCATE 26,56:PRINT USING "VB=##.## cubic feet";VB

    IF DESIGN$="sealed" THEN
      LOCATE 27,56:PRINT USING "F3=###.# hertz";F3
    END IF

    IF DESIGN$="optimal ported" THEN
      LOCATE 27,56:PRINT USING "FB=###.# hertz";FB
      LOCATE 28,56:PRINT USING "F3=###.# hertz";FH;
    END IF

    IF DESIGN$="non-optimal, ported" THEN
      LOCATE 27,56:PRINT USING "FB=###.# hertz";FB
    END IF

  ELSE
    IF VIDEOTYPE$="EGA" THEN COLOR GRAPHKOLORA%, GRAPHKOLORB%

    LOCATE 2,1:PRINT "VOLUME"
    LOCATE 3,1:PRINT ROUND(VB,2);"ft^3"

    IF DESIGN$="sealed" THEN
      LOCATE 5,1:PRINT "F3:"
      LOCATE 6,1:PRINT ROUND(F3,2);"hz"
    END IF

    IF DESIGN$="optimal ported" THEN
      LOCATE 5,1:PRINT "F3:"
      LOCATE 6,1:PRINT ROUND(FH,2);"hz"
      LOCATE 8,1:PRINT "TUNING:"
      LOCATE 9,1:PRINT ROUND(FB,2);"hz"
    END IF

    IF DESIGN$="non-optimal, ported" THEN
      LOCATE 5,1:PRINT "TUNING:"
      LOCATE 6,1:PRINT ROUND(FB,2);"hz"
    END IF

    LOCATE 24,12:PRINT D$;

  END IF

  CALL WAITFOKEY

  SCREEN 0
  IF VIDEOTYPE$<>"HERC" THEN COLOR KOLORA%,KOLORB%
  $FLOAT EMULATE
RETURN

BYEBYE:            ' LETS GET OUTA HERE ROUTINE!
  CLS
  LOCATE 10,14:PRINT"You are about to EXIT this program and return to DOS..."
  LOCATE 12,25:PRINT"Hit C to go back to the program"
  LOCATE 14,18:PRINT"Any other key will complete the exit to DOS."

  CALL WAITFOKEY

  IF K$="C" OR K$="c" THEN RETURN

  SCREEN 0
  KEY ON
  CLS
  END

SUB WAITFOKEY                'HIT-ANY-KEY LOOP
  SHARED K$
  K$=""
  WHILE NOT INSTAT : WEND
  K$=INKEY$
END SUB

SUB DRIVERDATIN              'LOAD DRIVER DATA FROM DISK
  SHARED D$, FS, QTS, VAS, DPATH$, FILENAME$, WAY$
  WAY$="LOAD"

  DO
    REPEATFLAG%=0
    CALL GENDIRECTORY
    IF FILENAME$="" THEN EXIT SUB
    IF MID$(FILENAME$,2,1)=":" OR LEFT$(FILENAME$,1)="\" THEN
      IF RIGHT$(FILENAME$,1)="\" OR RIGHT$(FILENAME$,1)=":" THEN
        DPATH$=FILENAME$
        REPEATFLAG%=1
      END IF
    END IF
  LOOP WHILE REPEATFLAG%=1

  FILENAME$=DPATH$+FILENAME$+".DRI"
  OPEN FILENAME$ FOR INPUT AS #1
  INPUT #1, D$,FS,QTS,VAS
  CLOSE
END SUB

SUB DRIVERDATOUT             'SAVE DRIVER DATA TO DISK
  SHARED D$, FS, QTS, VAS, DPATH$, FILENAME$, WAY$
  WAY$="SAVE"

  DO
    REPEATFLAG%=0
    CALL GENDIRECTORY
    IF FILENAME$="" THEN EXIT SUB
    IF MID$(FILENAME$,2,1)=":" OR LEFT$(FILENAME$,1)="\" THEN
      IF RIGHT$(FILENAME$,1)="\" OR RIGHT$(FILENAME$,1)=":" THEN
        DPATH$=FILENAME$
        REPEATFLAG%=1
      END IF
    END IF
  LOOP WHILE REPEATFLAG%=1

  FILENAME$=DPATH$+FILENAME$+".DRI"
  PRINT:PRINT"Saving driver data to disk . . ."

  OPEN FILENAME$ FOR OUTPUT AS #1
    PRINT#1,D$
    PRINT#1,FS
    PRINT#1,QTS
    PRINT#1,VAS
  CLOSE
END SUB

SUB GENDIRECTORY             'GET THE DISK DIRECTORY AND/OR FILENAME
  SHARED DPATH$, FILENAME$, WAY$
  CLS
  PRINT:PRINT"These are the driver files available on:"
  PRINT DPATH$+"*.DRI"
  PRINT
  FILES DPATH$+"*.DRI"
  PRINT:PRINT:PRINT:PRINT"Enter filename you wish to ";WAY$;" (no ext.)"
  INPUT FILENAME$
END SUB

SUB BOXSIZE                  'GOLDEN RECTANGLE BOX DIMENSIONS
  SHARED VB
  CLS
  LOCATE 3,14:PRINT"The following internal dimensions will produce"
  LOCATE 4,14:PRINT"an enclosure based on golden rectangle proportions,"
  LOCATE 5,14:PRINT"minimizing resonance problems, and having a pleasing"
  LOCATE 6,14:PRINT"appearance. (volume is the current working volume"
  LOCATE 7,14:PRINT"plus ten percent for braces and internal parts.)"
  LOCATE 9,14:PRINT"Note: parallel wall enclosures do not typically"
  LOCATE 10,14:PRINT"achieve maximum performance- use with caution!"
  VBTEN=VB*1.1
  LOCATE 12,22:PRINT USING"Enclosure volume= ###.## cubic feet";VBTEN
  CID=VB*1728*1.1
  WIDE=CID^(1/3)
  DEPTH=WIDE*.618
  HEIGHT=WIDE*1.618
  LOCATE 14,29:PRINT USING"Height =###.## inches";HEIGHT
  LOCATE 15,29:PRINT USING"Width  =###.## inches";WIDE
  LOCATE 16,29:PRINT USING"Depth  =###.## inches";DEPTH
  LOCATE 20,24:PRINT"Hit any key to return to menu #2"
  CALL WAITFOKEY
END SUB

SUB VENTLENGTH               'VENT LENGTH CALCULATION ROUTINE
  SHARED QUERY$, MINALLOWVAL!, MAXALLOWVAL!, OLDVAL!, NEWVAL!,_
                 VENTDIA, FB, VB, K$
  DO
    CLS
    LOCATE 3,20:PRINT"VENT LENGTH CALCULATOR FOR ROUND TUBING"
    PRINT:PRINT:PRINT

    QUERY$="Enter tubing ID in inches"
    MINALLOWVAL!=.5
    MAXALLOWVAL!=12
    OLDVAL!=VENTDIA
    GOSUB STANDARDDATAIN
    VENTDIA=NEWVAL!

    QUERY$="Enter tuning frequency in Hertz"
    MINALLOWVAL!=1
    MAXALLOWVAL!=999
    OLDVAL!=FB
    GOSUB STANDARDDATAIN
    TEMPFB=NEWVAL!

    QUERY$="Enter enclosure volume"
    MINALLOWVAL!=.01
    MAXALLOWVAL!=999
    OLDVAL!=VB
    GOSUB STANDARDDATAIN
    TEMPVB=NEWVAL!

    TEMPVB=TEMPVB*1728
    VENTRAD=VENTDIA/2
    VENTL=((1.463*1E+07*VENTRAD^2)/(TEMPFB^2*TEMPVB))-1.463*VENTRAD
    LOCATE 16,25:PRINT USING"The vent length = ##.## inches";VENTL

    IF VENTL<0 THEN
      LOCATE 18,11:PRINT"WARNING: Negative vent lengths are difficult to ";
      PRINT"fabricate!"
    END IF

    LOCATE 20,20:PRINT"Hit 'R' to repeat, any other for menu #2"
    CALL WAITFOKEY
    IF K$="R" OR K$="r" THEN REPEATFLAG%=1 ELSE REPEATFLAG%=0
  LOOP UNTIL REPEATFLAG%=0
END SUB

DAMAGEINIT:                  'SPECIAL ERROR HANDLER FOR SETUP FILE
RESUME NEXT

DAMAGECONTROL:               'STANDARD ERROR HANDLER

  FOR N%=150 TO 40 STEP -1   'MAKE A MILDLY OFFENSIVE SOUND
    SOUND N%,.02
  NEXT N%
  SOUND 40,5

  PRINT"AN ERROR HAS OCCURRED- THE ERROR CODE=";ERR
  IF ERR=6 THEN PRINT"OVERFLOW ERROR!"
  IF ERR=11 THEN PRINT"DIVISION BY ZERO ERROR!"
  IF ERR=27 THEN PRINT"PLEASE CHECK PRINTER!"
  IF ERR=25 THEN PRINT"DEVICE FAULT- CHECK PRINTER!"
  IF ERR=53 THEN PRINT"DATA FILE(S) NOT FOUND"
  IF ERR=61 THEN PRINT"DISK IS FULL!"
  IF ERR=67 THEN PRINT"TOO MANY FILES!"
  IF ERR=71 THEN PRINT"DRIVE NOT READY- CHECK DRIVE!"
  IF ERR=72 THEN PRINT"DISK MEDIA ERROR- CHECK MEDIA!"
  DELAY 2
RESUME NEXT

SUB FOOLISHNESS              'FUTURE ROUTINE MESSAGE
  CLS
  LOCATE 12,20:PRINT"This area reserved for future additions."
  PRINT
  IF RND(1) > 0.5 THEN
    LOCATE 14,14:PRINT"You think education is expensive.... try ignorance!"
  ELSEIF RND(0) > 0.25 THEN
    LOCATE 14,15:PRINT"On the other hand, we know some EEs who can't get"
    LOCATE 15,15:PRINT"the polarity right when screwing in a light bulb!"
  ELSE
    LOCATE 14,16:PRINT"The VGA opening screen reminded you of what!!!"
  END IF
  DELAY 4
END SUB

SUB VOLCONVERT     'CONVERSION FROM LITERS TO CUBIC FEET AND BACK AGAIN
  DO
    CLS
    LOCATE 3,24:PRINT"LITER <==> CUBIC FOOT CONVERSION"
    LOCATE 8,15:PRINT"Enter the volume, followed by L or F to indicate"
    LOCATE 9,15:PRINT"liters or cubic feet (such as 99.9L).  The answer"
    LOCATE 10,15:PRINT"will be returned in the opposite units."
    LOCATE 12,15
    INPUT VOL$

    CUBICF!=VAL(VOL$)*.03531466!
    LITER!=VAL(VOL$)*28.31684659!

    ERRORFLAG%=1

    IF RIGHT$(VOL$,1)="L" OR RIGHT$(VOL$,1)="l" THEN
      LOCATE 15,22:PRINT ROUND(VAL(VOL$),4);"liters =";
      PRINT ROUND(CUBICF!,4);"cubic feet"
      ERRORFLAG%=0
    END IF

    IF RIGHT$(VOL$,1)="F" OR RIGHT$(VOL$,1)="f" THEN
      LOCATE 15,22:PRINT ROUND(VAL(VOL$),4);"cubic feet =";
      PRINT ROUND(LITER!,4);"liters"
      ERRORFLAG%=0
    END IF

    IF ERRORFLAG%=1 THEN
      SOUND 50,5                       'MAKE A LOW PITCHED BEEP
      LOCATE 16,22:PRINT"INCORRECT FORMAT- USE L OR F SUFFIX!"
    END IF

    LOCATE 22,33:PRINT"Hit any key"
    CALL WAITFOKEY
  LOOP WHILE ERRORFLAG%=1
END SUB

SUB UNIVPRINT SHARED         ' UNIVERSAL PRINTOUT ROUTINE
  LPRINT:LPRINT
  LPRINT "Driver name: ";D$
  LPRINT "Design type: ";DESIGN$
  LPRINT "Parameters-"
  LPRINT USING "  Free air resonance: ###.## hertz";FS
  LPRINT USING "  Qts               :   #.####";QTS
  LPRINT USING "  Vas               :  ##.####";VAS
  LPRINT
  LPRINT USING "Enclosure volume    :  ##.## cubic feet";VB

  IF DESIGN$="optimal ported" THEN
    LPRINT USING "Enclosure tuning    :  ##.## hertz";FB
    LPRINT USING "Three dB down at    : ###.## hertz";FH
  END IF

  IF DESIGN$="sealed" THEN
    LPRINT USING "Three dB down at    : ###.## hertz";F3
    LPRINT USING "Qtc                 :   #.####";TC
    LPRINT USING "Alpha               :  ##.####";A
    LPRINT USING "System resonance    : ###.#### hertz";FC
  END IF

  IF DESIGN$="non-optimal, ported" THEN
    LPRINT USING "Enclosure tuning    : ###.## hertz";FB
  END IF

END SUB

SUB SETUPDATAOUT SHARED      'SCREEN AND COLOR SELECTION ROUTINE
  DO
    REPEATFLAG%=0
    ODPATH$=DPATH$
    IF AUTOFLAG%=1 THEN OVIDEOTYPE$="AUTO" ELSE OVIDEOTYPE$=VIDEOTYPE$
    SCREEN 0,0,0
    CLS
    LOCATE 3,20:PRINT"DISPLAY TYPE, COLOR, AND PATH SELECTION"
    LOCATE 6,2:PRINT"Select HERC, CGA, EGA, VGA, or AUTO";
    PRINT" (default is ";OVIDEOTYPE$;")";
    LOCATE ,60
    INPUT VIDEOTYPE$
    IF VIDEOTYPE$="" THEN VIDEOTYPE$=OVIDEOTYPE$
    IF VIDEOTYPE$<>"HERC" AND VIDEOTYPE$<>"CGA" AND VIDEOTYPE$<>"EGA" AND_
       VIDEOTYPE$<>"VGA" AND VIDEOTYPE$<>"AUTO" THEN BEEP:REPEATFLAG%=1
  LOOP UNTIL REPEATFLAG%=0

  IF VIDEOTYPE$="AUTO" THEN
    AUTOFLAG%=1
    CALL LOOKFOVID
  ELSE
    AUTOFLAG%=0
  END IF

  PRINT

  QUERY$="Select text color 0-15"
  MINALLOWVAL% = 0
  MAXALLOWVAL% = 15
  OLDVAL% = KOLORA%
  GOSUB STANDARDINTIN
  KOLORA% = NEWVAL%

  QUERY$="Select background color 0-7"
  MINALLOWVAL% = 0
  MAXALLOWVAL% = 7
  OLDVAL% = KOLORB%
  GOSUB STANDARDINTIN
  KOLORB% = NEWVAL%

  PRINT" Enter the drive and path for driver file storage in exactly"
  PRINT" this form=>    C:\NAME1\NAME2\...\NAMEX\"
  PRINT" The default is ";DPATH$
  LOCATE ,15
  INPUT DPATH$
  IF DPATH$="" THEN DPATH$=ODPATH$
  PRINT

  IF VIDEOTYPE$<>"HERC" THEN
    QUERY$="Enter graph color 1-15"
    MINALLOWVAL% = 1
    MAXALLOWVAL% = 15
    OLDVAL% = GRAPHKOLORA%
    GOSUB STANDARDINTIN
    GRAPHKOLORA% = NEWVAL%

    QUERY$="Enter graph background 0-15"
    MINALLOWVAL% = 0
    MAXALLOWVAL% = 15
    OLDVAL% = GRAPHKOLORB%
    GOSUB STANDARDINTIN
    GRAPHKOLORB% = NEWVAL%

    IF (VIDEOTYPE$="EGA") OR (VIDEOTYPE$="VGA") THEN
      QUERY$="Enter plot color 0-15"
      MINALLOWVAL% = 0
      MAXALLOWVAL% = 15
      OLDVAL% = GRAPHKOLORC%
      GOSUB STANDARDINTIN
      GRAPHKOLORC% = NEWVAL%
    END IF

  END IF

  QUERY$="Enter plot resolution: 1-20 hz"
  MINALLOWVAL% = 1
  MAXALLOWVAL% = 20
  OLDVAL% = RESOL%
  GOSUB STANDARDINTIN
  RESOL% = NEWVAL%

  SCREEN 0
  IF RIGHT$(VIDEOTYPE$,2)="GA" THEN COLOR KOLORA%,KOLORB%
  CLS
  LOCATE 5,18:PRINT"This is what the text display will look like"
  LOCATE 7,18:PRINT"The path is=> ";DPATH$
  LOCATE 9,18:PRINT"Hit a key to see the graph, then a key to return"
  CALL WAITFOKEY
  GOSUB PRINTGRAPH
  SCREEN 0
  IF RIGHT$(VIDEOTYPE$,2)="GA" THEN COLOR KOLORA%,KOLORB%
  CLS
  LOCATE 5,10:PRINT"Hit y to save setup, any other for menu #2"
  CALL WAITFOKEY
  IF K$="Y" OR K$="y" THEN
    IF AUTOFLAG%=1 THEN VIDEOTYPE$="AUTO"
      OPEN "LOUDSP.SCR" FOR OUTPUT AS #1
      WRITE#1,VIDEOTYPE$
      WRITE#1,KOLORA%
      WRITE#1,KOLORB%
      WRITE#1,GRAPHKOLORA%
      WRITE#1,GRAPHKOLORB%
      WRITE#1,GRAPHKOLORC%
      WRITE#1,RESOL%
      WRITE#1,DPATH$
    CLOSE
    IF AUTOFLAG%=1 THEN CALL LOOKFOVID
  END IF
END SUB

SUB SETUPDATAIN              'READ THE SETUP DATA FILE- LOUDSP.SCR
  SHARED VIDEOTYPE$, KOLORA%, KOLORB%, KOLORC%,_
         GRAPHKOLORA%, GRAPHKOLORB%, GRAPHKOLORC%, RESOL%, DPATH$
  ON ERROR GOTO DAMAGEINIT
  OPEN "LOUDSP.SCR" FOR INPUT AS #1
  INPUT #1, VIDEOTYPE$, KOLORA%, KOLORB%, GRAPHKOLORA%,_
            GRAPHKOLORB%, GRAPHKOLORC%, RESOL%, DPATH$
  CLOSE
  ON ERROR GOTO DAMAGECONTROL
END SUB

SUB SETUPCHECK               'CHECK FOR COLOR CONFLICTS OR NO FILE
  SHARED KOLORA%, KOLORB%, KOLORC%, GRAPHKOLORA%, GRAPHKOLORB%,_
         GRAPHKOLORC%, VIDEOTYPE$
  IF KOLORA%=KOLORB% OR GRAPHKOLORA%=GRAPHKOLORB% THEN
    SCREEN 0,0,0
    CLS
    PRINT
    PRINT
    PRINT
    PRINT
    PRINT "     Hey dude!  I can't find the setup file, but no problemo, OK?"
    PRINT "     Please select the setup option in menu #2 when you get a"
    PRINT "     chance.  If you'll give me a couple seconds, I'll set the"
    PRINT "     video mode to CGA, and the colors to somthing useable..."
    PRINT "     If you need Hercules, see the doc file that goes with the"
    PRINT "     program!"
    VIDEOTYPE$="CGA":KOLORA%=14:KOLORB%=1:KOLORC%=0
    GRAPHKOLORA%=14:GRAPHKOLORB%=1:GRAPHKOLORC%=15
    DELAY 15
  END IF
END SUB

SUB DOSSHELL                 'SHELL TO DOS ROUTINE
  SHELL
END SUB

SUB MAXPOWER SHARED          'MAXPOWER


  CLS
  LOCATE 3,10:PRINT"MAXIMUM POWER & SPL RELATIONSHIPS"
  LOCATE 7,10:PRINT"Power values will be based on the current active"
  LOCATE 8,10:PRINT"design, ie: the last design entered into the program."
  LOCATE 9,10:PRINT"If you have yet to calculate a design, please hit"
  LOCATE 10,10:PRINT"'R' to return to the main menu.  hit any other key"
  LOCATE 11,10:PRINT"to continue with this selection."
  CALL WAITFOKEY
  IF K$="R" OR K$="r" THEN RETURN

  CLS
  PRINT:PRINT:PRINT

  QUERY$="Enter actual moving diameter in inches"
  MINALLOWVAL! = 1
  MAXALLOWVAL! = 999
  OLDVAL! = ACDI
  GOSUB STANDARDDATAIN
  ACDI = NEWVAL!

  QUERY$="Enter p-p driver excursion in inches"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 6
  OLDVAL! = EXCI
  GOSUB STANDARDDATAIN
  EXCI = NEWVAL!

  QUERY$="Enter maximum input in Watts RMS"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = WRMS
  GOSUB STANDARDDATAIN
  WRMS = NEWVAL!

  QUERY$="Enter DC resistance in ohms"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = RE
  GOSUB STANDARDDATAIN
  RE = NEWVAL!

  QUERY$="Enter electrical Q [Qes]"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = QES
  GOSUB STANDARDDATAIN
  QES = NEWVAL!

  VRMS=SQR(WRMS*RE)
  KP=SQR(VAS*FS^3/QES/RE)/753
  KD=.3535*SQR(VAS/FS/QES/RE)/ACDI^2

  IF DESIGN$="optimal ported" OR DESIGN$="non-optimal, ported" THEN
    H=FB/FS
    A=VAS/VB
    Q7=7
  ELSE
    H=.0001
    Q7=10000
  END IF

  H2=SQR(H)
  A1=H2/Q7+1/QTS/H2
  A2=1/QTS/Q7+(A+1+H^2)/H
  A3=H2/QTS+1/Q7/H2
  F1=H2*FS

  CLS                        'START OF SCREEN OUTPUT ROUTINE
  LOCATE 2,5:PRINT"FREQ"
  LOCATE 2,25:PRINT"RESPONSE (dB)"
  LOCATE 2,45:PRINT"MAX PWR.(RMS)"
  LOCATE 2,65:PRINT"SPL (dB)"
  PRINT
  FOR F%=20 TO 200 STEP 10
    X=F%/F1
    Y=X^4/SQR((X^4-A2*X^2+1)^2+(A1*X^3-A3*X)^2)
    Y1=Y*SQR((X^2/H-1)^2+(X/Q7)^2/H)/X^4
    E1=EXCI/KD/Y1/39.37
    IF E1<VRMS THEN E2=E1
    IF VRMS<=E1 THEN E2=VRMS
    RESPONSE=20*LOG(Y)/LOG(10)
    SPL=20*LOG(KP*Y*E2*50000!)/LOG(10)
    POWER=E2^2/RE
    PRINT USING"    ###                    ###.##";F%,RESPONSE;
    PRINT USING"              ###.#             ###.##";POWER,SPL
  NEXT F%
  LOCATE 24,23:PRINT"HIT ANY KEY TO RETURN TO MAIN MENU";
  CALL WAITFOKEY
END SUB

SUB CROSSOVER SHARED         'CROSSOVER DESIGN ROUTINES (L-R ALLPASS TYPE)
  CLS
  LOCATE 3,17:PRINT"SECOND ORDER ALL PASS CROSSOVER (APC) DESIGNER"
  LOCATE 10

  QUERY$="Two (2) or three (3) way design"
  MINALLOWVAL! = 2
  MAXALLOWVAL! = 3
  OLDVAL! = WAY
  GOSUB STANDARDDATAIN
  WAY = NEWVAL!

  QUERY$="Enter woofer impedance in ohms"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL!=RL
  GOSUB STANDARDDATAIN
  RL = NEWVAL!

  QUERY$="Enter tweeter impedance in ohms"
  MINALLOWVAL! = .01
  MAXALLOWVAL! = 999
  OLDVAL! = RH
  GOSUB STANDARDDATAIN
  RH = NEWVAL!

  IF WAY=3 THEN
    QUERY$="Enter midrange impedance in ohms"
    MINALLOWVAL! = .01
    MAXALLOWVAL! = 999
    OLDVAL! = RM
    GOSUB STANDARDDATAIN
    RM = NEWVAL!
  END IF

  QUERY$="Enter woofer crossover frequency"
  MINALLOWVAL! = 5
  MAXALLOWVAL! = 20000
  OLDVAL! = FL
  GOSUB STANDARDDATAIN
  FL = NEWVAL!

  IF WAY=3 THEN
    QUERY$="Enter tweeter crossover frequency"
    MINALLOWVAL! = 5
    MAXALLOWVAL! = 20000
    OLDVAL! = FH
    GOSUB STANDARDDATAIN
    FH = NEWVAL!
  END IF

  IF WAY=2 THEN
    CALL TWOWAYCALC
  ELSE

    FM=SQR(FL*FH)
    W1=2*PI*FL
    W2=2*PI*FM
    W3=2*PI*FH
    S=FH/FL
    R=SQR(S)
    A=(2*(S-1))/SQR((S*S)-(2*S))
    H=S+(A*A)-4+(3/S)
    AA=A*(R+(1/R))
    B=S+(A*A)+(1/S)
    C1=1/A/RL/W1
    L1=A*RL/W1
    L2=A*RH/W3
    C2=1/A/RH/W3
    K=B-1
    E=AA*(1-1/K)
    RA=RM*(K/H-1)
    R0=RM
    C3=1/AA/R0/W2
    L3=AA*R0/W2/K
    L4=E*R0/W2
    C4=K/E/R0/W2
    CALL SCHEMATIC
    LOCATE 13,17:PRINT USING"For the tweeter Z1=###.## uF and ";C2*1E6;
    PRINT USING"Z2=###.## mH";L2*1000
    LOCATE 15,17:PRINT"For the midrange two stages are required:"
    LOCATE 16,17:PRINT USING"Stage 1  Z1=###.## uF and ";C4*1E6;
    PRINT USING"Z2=###.## mH";L4*1000
    LOCATE 17,17:PRINT USING"Stage 2  Z1=###.## mH and ";L3*1000;
    PRINT USING"Z2=###.## uF";C3*1E6
    LOCATE 19,17:PRINT USING"For the woofer Z1=###.## mH and ";L1*1000;
    PRINT USING"Z2=###.## uF";C1*1E6
    LOCATE 22,17:PRINT"Be sure to reverse the polarity of the midrange!"
    CALL WAITFOKEY
  END IF
END SUB


SUB SCHEMATIC                ' SCHEMATIC DIAGRAM ROUTINE
  CLS
  PRINT
  PRINT"                         Ŀ                                    "
  PRINT"      Ĵ   Z 1   >  "
  PRINT"        +                                              +    "
  PRINT"                                             Ŀ                "
  PRINT"           INPUT                                Z 2         TO DRIVER "
  PRINT"                                                 OR NEXT STAGE"
  PRINT"                                                                       "
  PRINT"        -                                                         -    "
  PRINT"      >  "
END SUB

SUB TWOWAYCALC SHARED        ' TWO WAY DESIGN CALCULATION ROUTINE

  W1=2*PI*FL
  C1=1/(2*RL*W1)
  L1=2*RL/W1
  L2=2*RH/W1
  C2=1/(2*RH*W1)

  CALL SCHEMATIC
  LOCATE 13,17:PRINT USING"For the tweeter Z1=###.## uF and ";C2*1E6;
  PRINT USING"Z2=###.## mH";L2*1000
  LOCATE 15,17:PRINT USING"For the woofer Z1=###.## mH and ";L1*1000;
  PRINT USING"Z2=###.## uF";C1*1E6
  LOCATE 17,17:PRINT"Be sure to reverse the polarity of the tweeter!"
  LOCATE 22,34:PRINT"Hit any key"
  CALL WAITFOKEY
END SUB

SUB LOOKFOVID                'PROBE THE HARDWARE TO DETERMINE VIDEO ADAPTOR
  SHARED BUFFER%(), VIDEOTYPE$

  REG 1, &h1B00              'SET AX REGISTER TO BIOS SERVICE 1Bh
  REG 7, VARPTR(BUFFER%(0))  'SET BP REGISTER TO BUFFER OFFSET ADDRESS
  REG 9, VARSEG(BUFFER%(0))  'SET ES REGISTER TO BUFFER SEGMENT ADDRESS
  CALL INTERRUPT &h10        'CALL VIDEO INTERRUPT

  IF (REG(1) AND &h1B) = &h1B THEN     'CHECK AL FOR 1Bh SHOWING VGA
    VIDEOTYPE$="VGA"
  ELSE
    CALL INTERRUPT &h11
    CARD = (REG(1) AND &h30)           'GET THE INITIAL VIDEO MODE BITS
    IF CARD = &h00 THEN CARD = 0
    IF CARD = &h10 THEN CARD = 1
    IF CARD = &h20 THEN CARD = 2
    IF CARD = &h30 THEN CARD = 3

    REG 1, &h0F00
    CALL INTERRUPT &h10
    VMODE=REG(1)
    VMODE=VMODE AND &hFF               'GET THE CURRENT VIDEO MODE

    VIDEOTYPE$="UNKNOWN"
    DEF SEG = &h40
    IF PEEK(135) THEN                  'NON-ZERO AT 487h INDICATES EGA
      VIDEOTYPE$="EGA"
    ELSE
      IF (CARD=3) THEN

        N=0
        DO
          IF (INP(&h3BA) AND 128) THEN VIDEOTYPE$="HERC":EXIT LOOP
          N=N+1
        LOOP WHILE N<1000

        IF VIDEOTYPE$="UNKNOWN" THEN VIDEOTYPE$="MDA"
      ELSE
        IF (CARD=2) OR (CARD=0) THEN
          IF (VMODE=2) THEN
            VIDEOTYPE$="COMPAQ"
          ELSE
            VIDEOTYPE$="CGA"
          END IF
        END IF
      END IF
    END IF
  END IF

  DEF SEG

  IF VIDEOTYPE$="COMPAQ" OR VIDEOTYPE$="UNKNOWN" OR VIDEOTYPE$="MDA" THEN
    BEEP
    PRINT"CAUTION: Video type not identified, please set set manually..."
    PRINT"         See program documentation!"
    DELAY 3
    VIDEOTYPE$="CGA"
  END IF
END SUB

SUB FIRSTSCREEN1             'DRAW SPEAKER W/ CONE PULLED IN ON PAGE #0
  SHARED VIDEOTYPE$
  WINDOW SCREEN (0,750)-(1000,0)       'NORMALIZE SCREEN TO 1000 x 750
  CLS
  LINE (15,15)-(985,735),,B            'DRAW THE OUTER BOX
  LINE (25,25)-(975,725),,B            'DRAW THE INNER BOX

  CIRCLE (365,180),30,,4.547,7.689     'UPPER ROLL
  CIRCLE (365,570),30,,4.877,8.019     'LOWER ROLL
  LINE (240,330)-(360,210)             'UPPER HALF OF CONE
  LINE (240,420)-(360,540)             'LOWER HALF OF CONE
  CIRCLE (190,375),65,,5.58,7.02       'DUSTCAP
  LINE (150,330)-(240,330)             'UPPER VC
  LINE (150,420)-(240,420)             'LOWER VC
  CIRCLE (857,375),35,,1.867,4.416     'TWEETER DOME
  CALL STATIONARYIMAGE
END SUB

SUB FIRSTSCREEN2             'DRAW SPEAKER W/ CONE PUSHED OUT ON PAGE #1
  SHARED KOLORA%, KOLORB%
  SCREEN ,,1,0
  COLOR KOLORA%, KOLORB%
  CLS
  LINE (15,15)-(985,735),,B            'DRAW THE OUTER BOX
  LINE (25,25)-(975,725),,B            'DRAW THE INNER BOX
  CIRCLE (375,180),30,,4.877,8.019     'UPPER ROLL
  CIRCLE (375,570),30,,4.547,7.689     'LOWER ROLL
  LINE (260,330)-(380,210)             'UPPER HALF OF CONE
  LINE (260,420)-(380,540)             'LOWER HALF OF CONE
  CIRCLE (210,375),65,,5.58,7.02       'DUSTCAP
  LINE (170,330)-(260,330)             'UPPER VC
  LINE (170,420)-(260,420)             'LOWER VC
  CIRCLE (855,375),35,,1.745,4.538     'TWEETER DOME
  CALL STATIONARYIMAGE
END SUB

SUB ROTATE                   'ALTERNATE SCREENS TO SIMULATE MOTION
  T=0.2
  K$=""
  DO
    screen ,,,1              'FLIP TO SCREEN PAGE #1
    delay T                  'GIVE IT TIME TO SINK IN
    screen ,,,0              'FLIP TO SCREEN PAGE #2
    delay T                  'GIVE IT TIME TO SINK IN
    K$=INKEY$                'SEE IF THEY GOT BORED AND PRESSED A KEY
    IF K$="F" THEN T=T-.02
    IF K$="S" THEN T=T+.02
    IF T<0 THEN T=0:BEEP
    IF K$=" " THEN EXIT LOOP
  LOOP                       'DO IT ALL AGAIN
END SUB

SUB TITLETEXT
  SHARED VERSION$
  LOCATE 11,30:PRINT"LOUDSPEAKER DESIGN"
  LOCATE 13,30:PRINT"FOR THE IBM COMPATIBLE COMPUTER"
  LOCATE 15,30:PRINT VERSION$
END SUB

SUB STATIONARYIMAGE                    'NON MOVING STUFF FOR BOTH SCREENS
  LINE (130,300)-(130,450)             'LEFT SIDE OF MAGNET
  LINE (125,320)-(130,320)             'TOP OF REAR DETAIL
  LINE (125,430)-(130,430)             'BOTTOM OF  REAR DETAIL
  LINE (125,320)-(125,430)             'LEFT SIDE OF REAR DETAIL
  LINE (130,300)-(200,300)             'TOP OF MAGNET
  LINE (130,450)-(200,450)             'BOTTOM OF MAGNET
  LINE (200,300)-(200,320)             'UPPER RIGHT OF MAGNET
  LINE (200,450)-(200,430)             'LOWER LEFT OF MAGNET
  LINE (140,320)-(200,320)             'TOP OF PLUG
  LINE (140,430)-(200,430)             'MORE INTERNAL DETAILS
  LINE (140,320)-(140,340)
  LINE (140,430)-(140,410)
  LINE (140,340)-(200,340)
  LINE (140,410)-(200,410)
  LINE (200,340)-(200,410)             'END OF MAGNET PLUG
  LINE (200,315)-(370,150)             'INSIDE TOP OF BASKET
  LINE (200,435)-(370,600)             'INSIDE BOTTOM OF BASKET
  LINE (370,110)-(370,150)             'TOP TAB
  LINE (365,110)-(365,150)             'LEFT SIDE OF TAB
  LINE (370,110)-(365,110)             'UPPER MOST EDGE
  LINE (370,640)-(370,600)             'BOTTOM TAB
  LINE (365,640)-(365,600)             'LEFT SIDE OF TAB
  LINE (365,640)-(370,640)             'BOTTOM MOST EDGE
  LINE (850,200)-(860,550),,B          'TWEETER PLATE
  LINE (860,250)-(910,500),,B          'TWEETER MAGNET
  CALL TITLETEXT
END SUB
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>> END OF LISTING <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
